﻿using Microscopic_Traffic_Simulator___Model.GeometricObjects;
using Microscopic_Traffic_Simulator___Model.GeometricObjects.Lanes;
using System.Collections.Generic;
using System.Windows;
using System.Windows.Media;

namespace Microscopic_Traffic_Simulator.Renderers
{
    /// <summary>
    /// Geometric topology renderer.
    /// </summary>
    class TopologyRenderer : VisualCanvasRenderer
    {
        private const double GeneratorCircleRadius = 2.0;

        /// <summary>
        /// Geoemtric renderer to render.
        /// </summary>
        private GeometricTopology geometricTopology;
        /// <summary>
        /// Geoemtric renderer to render.
        /// </summary>
        internal GeometricTopology GeometricTopology
        {
            set { geometricTopology = value; }
        }

        /// <summary>
        /// Initialization of geometric topology renderer.
        /// </summary>
        /// <param name="visual">Drawing visual to render to.</param>       
        internal TopologyRenderer(DrawingVisual visual) : base(visual) { }

        /// <summary>
        /// Redraw geometric topology on drawing visual.
        /// <param name="currentMouseLocation">Current mouse location</param>
        /// </summary>
        protected override void Render(Point currentMouseLocation)
        {
            RenderTopology();
        }
        
        /// <summary>
        /// Redraw geometric topology on drawing visual.
        /// </summary>
        internal void RenderTopology()
        {
            using (DrawingContext dc = visual.RenderOpen())
            {
                //new ZoomValuesGenerator().Draw(dc);
                foreach (var lane in geometricTopology.Lanes)
                {
                    if (lane is StraightLane)
                    {
                        dc.DrawLine(new Pen(Brushes.Black, 1),
                            TransformRealWorldPoint(lane.StartNode.Location),
                            TransformRealWorldPoint(lane.EndNode.Location));
                    }
                    else if (lane is BezierLane)
                    {
                        BezierLane bezierLane = lane as BezierLane;
                        dc.DrawGeometry(null, new Pen(Brushes.Black, 1), new BezierCurveGeometryCreator().GetBezierCurveGeometry(
                            TransformRealWorldPoint(bezierLane.StartNode.Location),
                            TransformRealWorldPoint(bezierLane.EndNode.Location),
                            TransformRealWorldPoint(bezierLane.FirstControlLocation),
                            TransformRealWorldPoint(bezierLane.SecondControlLocation)));
                    }

                    if (lane.StartNode.ContainsGenerator)
                    {
                        dc.DrawEllipse(Brushes.Blue, null, TransformRealWorldPoint(lane.StartNode.Location), 
                            GeneratorCircleRadius, GeneratorCircleRadius);
                    }
                }
            }
        }        
    }
}
